<p align="center">
    <img src="https://github.com/acemod/ACE3/raw/master/extras/assets/logo/black/ACE3-Logo.png#gh-light-mode-only" width="480">
    <img src="https://github.com/acemod/ACE3/raw/master/extras/assets/logo/white/ACE3-Logo.png#gh-dark-mode-only" width="480">
</p>

<p align="center">
    <a href="https://github.com/acemod/ACE3/releases/latest">
        <img src="https://img.shields.io/github/release/acemod/ACE3.svg?style=flat-square&label=Version" alt="ACE3 Version">
    </a>
    <a href="https://github.com/acemod/ACE3/issues">
        <img src="https://img.shields.io/github/issues-raw/acemod/ACE3.svg?style=flat-square&label=Issues" alt="ACE3 Issues">
    </a>
    <a href="https://github.com/acemod/ACE3/releases">
        <img src="https://img.shields.io/github/downloads/acemod/ACE3/total.svg?style=flat-square&label=Downloads" alt="ACE3 Downloads">
    </a>
    <a href="https://forums.bistudio.com/topic/181341-ace3-a-collaborative-merger-between-agm-cse-and-ace/?p=2859670">
        <img src="https://img.shields.io/badge/BIF-Thread-lightgrey.svg?style=flat-square" alt="BIF Thread">
    </a>
    <a href="https://github.com/acemod/ACE3/blob/master/LICENSE">
        <img src="https://img.shields.io/badge/License-GPLv2-red.svg?style=flat-square" alt="ACE3 License">
    </a>
    <a href="https://acemod.org/discord">
        <img src="https://img.shields.io/badge/Discord-Join-darkviolet.svg?style=flat-square" alt="ACE3 Discord">
    </a>
</p>

<p align="center">
    <sup><strong>Requires the latest version of <a href="https://github.com/CBATeam/CBA_A3/releases">CBA A3</a>.<br/>
    Visit us on <a href="https://twitter.com/ACE3Mod">Twitter</a> | <a href="https://www.facebook.com/ACE3Mod">Facebook</a> | <a href="https://www.youtube.com/c/ACE3Mod">YouTube</a> | <a href="https://www.reddit.com/r/arma/search?q=ACE&restrict_sr=on&sort=new&t=all">Reddit</a></strong></sup>
</p>

**ACE3** is a joint effort by the teams behind **ACE2**, **AGM** and **CSE** to improve the realism and authenticity of Arma 3.

The project is entirely **open-source** and all contributions are welcome. Feel free to maintain your own custom version, so long as the changes you make are open to the public in accordance with the GNU General Public License ([GPLv2](https://github.com/acemod/ACE3/blob/master/LICENSE)).

The mod is **built modularly**, so almost any included PBO can be easily removed from the configuration. This way, a team can maintain its own tailored version of ACE3 by simply excluding any components they don't need, or those possibly in conflict with other mods. Modules themselves, e.g. the medical system, also include various customization options, allowing mission designers to tweak the overall experience.

## Core features

- Brand new 3D interaction/action system
- Performance and reliability framework
- Focus on modularity and customization
- New flexible client and server settings & configuration
- Improved medical system with various levels (basic/advanced) focus on gameplay/realism
- Proper & consistent network-synced weather
- Wind and weather-based ballistics
- Captivity system
- Explosives system, including different trigger types
- Map screen improvements – marker placement and map tools
- Logistics
- Advanced missile guidance and laser designation

### Additional features

- Carrying and dragging
- Realistic names for vehicles and weapons
- A fire control system (FCS) for armored vehicles and helicopters
- Realistic ballistics/FCS calculated in Rust extensions
- Backblast area and overpressure simulation
- Disposable launchers
- Realistic G-forces
- Vehicle locking
- Realistic night and thermal vision modes
- Magazine repacking
- Realistic weapon overheating mechanic
- Combat deafness (temporary loss of hearing) simulation
- Improved interactions for AARs and ammo bearers
- Adjustable sniper scopes
- No idle animation with lowered weapon
- No talking player avatar
- Jumping over obstacles, climbing over walls and cutting down fences
- Vector, MicroDAGR and Kestrel devices<br>
***and much more...***

## Getting started

ACE3 requires Arma 3 and the latest version of <a href="https://github.com/CBATeam/CBA_A3/releases">CBA A3</a>. See the following pages for help and information on how to get started with ACE3:

- [Installation guide](https://ace3.acemod.org/wiki/user/installation-guide.html)
- [Information center](https://ace3.acemod.org/wiki/user/information-center.html)

## Contributing

You can help out with the ongoing development by looking for potential bugs in our code base, or by contributing new features. We are always welcoming new pull requests containing bug fixes, refactors and new features. We have a list of tasks and bugs on our issue tracker on Github. Please comment on issues if you want to contribute with, to avoid duplicating effort.

### Contribution guidelines

To contribute something to ACE3, simply fork this repository and submit your pull requests for review by other collaborators. See [the pull request guidelines](https://ace3.acemod.org/wiki/development/merging-pull-requests.html) for further information on this process.

### Submitting issues and requesting features

Please, use our [Issue Tracker](https://github.com/acemod/ACE3/issues) to report a bug, propose a feature, or suggest changes to the existing ones. See also:
- [How to report an issue](https://ace3.acemod.org/wiki/user/how-to-report-an-issue.html)
- [How to make a feature request](https://ace3.acemod.org/wiki/user/how-to-make-a-feature-request.html)

### Testing & building

To help us test the latest development changes, download the [artifact](https://github.com/acemod/ACE3/actions/workflows/arma.yml) of the branch you'd like to test or subscribe to "Anrop ACE3 Master" on the workshop to test `master` branch. Alternatively [build your own version](https://ace3.acemod.org/wiki/development/setting-up-the-development-environment.html).

### Get in touch

<table>
  <tr>
    <td><a href="https://acemod.org/discord">Discord</a></td>
    <td>We have a public Discord server that anyone can join. This is where all our developers and contributors hang out and where we make announcements</td>
  </tr>

  <tr>
    <td><a href="https://twitter.com/ACE3Mod">Twitter</a></td>
    <td>You can follow our Twitter account to get updates and various links to guides</td>
  </tr>
  <tr>
    <td><a href="https://www.facebook.com/ACE3Mod">Facebook</a></td>
    <td>You can follow our Facebook account to get updates and various links to guides</td>
  </tr>

  <tr>
    <td><a href="https://forums.bistudio.com/topic/181341-ace3-a-collaborative-merger-between-agm-cse-and-ace/?p=2859670">Bohemia Forum</a></td>
    <td>We have a dedicated thread on the Bohemia Forums for the ACE3 project</td>
  </tr>
</table>

## License

ACE3 is licensed under the GNU General Public License ([GPLv2](https://github.com/acemod/ACE3/blob/master/LICENSE)).
