<p align="center">
    <img src="https://github.com/acemod/ACE3/raw/master/extras/assets/logo/black/ACE3-Logo.jpg" width="480">
</p>

<p align="center">
    <a href="https://github.com/acemod/ACE3/releases/latest">
        <img src="https://img.shields.io/badge/Version-3.18.1-blue.svg?style=flat-square" alt="ACE3 版本">
    </a>
    <a href="https://github.com/acemod/ACE3/issues">
        <img src="https://img.shields.io/github/issues-raw/acemod/ACE3.svg?style=flat-square&label=Issues" alt="ACE3 問題">
    </a>
    <a href="https://github.com/acemod/ACE3/releases">
        <img src="https://img.shields.io/github/downloads/acemod/ACE3/total.svg?style=flat-square&label=Downloads" alt="ACE3 下載">
    </a>
    <a href="https://forums.bistudio.com/topic/181341-ace3-a-collaborative-merger-between-agm-cse-and-ace/?p=2859670">
        <img src="https://img.shields.io/badge/BIF-Thread-lightgrey.svg?style=flat-square" alt="波希米亞互動論壇上的文章">
    </a>
    <a href="https://github.com/acemod/ACE3/blob/master/LICENSE">
        <img src="https://img.shields.io/badge/License-GPLv2-red.svg?style=flat-square" alt="ACE3 條款">
    </a>
    <a href="https://acemod.org/discord">
        <img src="https://img.shields.io/badge/Discord-Join-darkviolet.svg?style=flat-square" alt="加入ACE3 Discord">
    </a>
</p>

<p align="center">
    <sup><strong>需要最新版本之 <a href="https://github.com/CBATeam/CBA_A3/releases">CBA A3</a>.<br/>
    在以下社群網站拜訪我們 <a href="https://twitter.com/ACE3Mod">推特</a> | <a href="https://www.facebook.com/ACE3Mod">臉書</a> | <a href="https://www.youtube.com/c/ACE3Mod">YouTube</a> | <a href="https://www.reddit.com/r/arma/search?q=ACE&restrict_sr=on&sort=new&t=all">Reddit</a></strong></sup>
</p>

**進階戰鬥環境3(ACE3)** 是由 **進階戰鬥環境2(ACE2)**, **可靠性遊戲模改(AGM)** 以及 **戰鬥空間強化(CSE)**的幕後團隊人員精心打造，用於改善武裝行動三裡面的真實與可靠性。

這整個項目是 **開放原始碼**並且樂意接受任何的維護。若要歡迎你建立維護你自訂版本的ACE3，只要你所做的向公眾所做更改是有遵守著「GNU通用公眾授權條款」 ([GPLv2](https://github.com/acemod/ACE3/blob/master/LICENSE)).

這個模組架構為 **模組化**設計,所以幾乎任何模組內包含的PBO元件可以輕鬆地從設置來移除。因此，一個團隊可以維護著藉由免除自己沒有打算加入的元件來量身訂製的ACE3版本，或者如果有與其他模組衝突。模塊本身，例如醫療系統，那就可以簡單的去除掉。而且，也包含許多可自訂義的設定，允許任務設計者來為整體的任務體驗從頭到尾的調教。

## 核心功能

- 全新的立體互動/動作系統
- 可靠又高效的框架
- 專注於可模組化與可自訂性
- 客戶端及伺服端全新的靈活的設置及配置
- 改進醫療系統並劃分為多層次(基礎/進階)以此專注於遊玩向或者真實向體驗
- 透過網路同步的精確且一致的天氣
- 以風和天氣為考量的彈道系統
- 戰俘系統
- 爆裂物系統，內含不同的觸發爆裂物的類型
- 地圖畫面的改進 - 標記的擺放以及地圖工具
- 後勤系統
- 進階的飛彈引導以及雷射指示器

### 添加功能

- 揹起與拖動。
- 還原真實世界的載具及武器名稱
- 裝甲載具以及直升機有著火控系統(FCS)
- 以C/C++編寫的真實彈道及火控運算插件
- 尾焰以及高壓範圍的模擬
- 一次性使用發射器
- 真實G力
- 載具上鎖系統
- 真實的熱傳導以及夜視模式
- 彈匣重填功能
- 真實的武器過熱機制
- 戰鬥耳聾(暫時性失去聽覺)模擬
- 改進行動後預覽以及火力掩護
- 可調性狙擊槍瞄具
- 當放下武器時沒有閒置動作
- 去除說話中玩家的提示
- 跳過障礙物，翻牆以及割開柵欄。
- Vector望遠鏡, 微型軍用GPS接收器以及獵隼4500測風儀裝置<br>
***不只這些呢...***

## 新手起步

ACE3需要最新版本的武裝行動3以及最新版本的 <a href="https://github.com/CBATeam/CBA_A3/releases">CBA A3</a>模組。以下的網頁可用於幫助以及提供安裝ACE3上的資訊。
- [安裝指南-英文](https://ace3.acemod.org/wiki/user/installation-guide.html)
- [資訊中心-英文](https://ace3.acemod.org/wiki/user/information-center.html)

## 維護

你透過幫忙找出我們原始碼的漏洞來幫助我們接下來的開發，或者維護著新功能。我們總是歡迎提交漏洞修補以及程式碼重構或者新功能。我們有列出我們遇到的問題或者目標在Github上如果有想要維護的話請在問題上留言避免多餘重複的付出。

### 維護指南

如果想要維護ACE3的某個部件的話， 簡單的分支該儲存庫並申請提交來讓合作者檢視。請記得如果你有修改PBO部件請將自己加入到作者們的文件 - [`AUTHORS.txt`](https://github.com/acemod/ACE3/blob/master/AUTHORS.txt);包括可連絡的電子信箱。

### 提交問題或者申請功能

麻煩，請使用我們的 [問題追蹤](https://github.com/acemod/ACE3/issues)來回報漏洞，想要的功能，或者建議調整目前已有的功能，也請到以下參閱:
- [如何回報問題-英文](https://ace3.acemod.org/wiki/user/how-to-report-an-issue.html)
- [如何申請功能-英文](https://ace3.acemod.org/wiki/user/how-to-make-a-feature-request.html)

### 測試與建構。

若要幫助我們測試最新的開發版所造成的更改，下載我們的主分支([直接下載](https://github.com/acemod/ACE3/archive/master.zip),或者 [git](https://help.github.com/articles/fetching-a-remote/))，然後用於編譯組建:

- [設置開發環境-英文](https://ace3.acemod.org/wiki/development/setting-up-the-development-environment.html) –一步一步的引導如何為了測試目的來正確的建構ACE3

### 聯繫

<table>
  <tr>
    <td><a href="https://acemod.org/discord">Discord</a></td>
    <td>我們有著公共的Discord團隊供大家加入，而該模組所有開發者以及維護者也會在此出現並公告</td>
  </tr>

  <tr>
    <td><a href="https://twitter.com/ACE3Mod">推特</a></td>
    <td>你可以追隨我們的推特帳號來獲得更新消息以及一些指南聯結。</td>
  </tr>
  <tr>
    <td><a href="https://www.facebook.com/ACE3Mod">臉書</a></td>
    <td>你可以追隨我們的臉書帳號來獲得更新消息以及一些指南聯結。</td>
  </tr>

  <tr>
    <td><a href="https://forums.bistudio.com/topic/181341-ace3-a-collaborative-merger-between-agm-cse-and-ace/?p=2859670">波希米亞論壇</a></td>
    <td>我們在波希米亞互動論壇上也有專門的ACE3之文章</td>
  </tr>  
</table>

## 條款

ACE3遵守在GNU通用公眾授權條款之下 ([GPLv2](https://github.com/acemod/ACE3/blob/master/LICENSE)).
